/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.model.search.ModelQuerySpec;
import org.eclipse.fordiac.ide.model.search.ModelSearchQuery;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public class ModelSearchPage
extends DialogPage
implements ISearchPage {
    public static final int NUMBER_OF_SEARCH_OPTIONS = 4;
    public static final int NUMBER_OF_SCOPES = 2;
    private ISearchPageContainer container;
    private Button instanceName;
    private Button pinName;
    private Button type;
    private Button comment;
    private Text query;
    private Button caseSensitive;
    private Button exactNameMatching;
    private Button interfaceValueMatching;
    private Button projectScope;
    private IProject curProject;

    public Button getInstanceName() {
        return this.instanceName;
    }

    public Button getPinName() {
        return this.pinName;
    }

    public Button getType() {
        return this.type;
    }

    public Button getComment() {
        return this.comment;
    }

    public ISearchPageContainer getContainer() {
        return this.container;
    }

    public Button getCaseSensitive() {
        return this.caseSensitive;
    }

    public void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(1).margins(LayoutConstants.getMargins()).generateLayout(parent);
        Composite composite = (Composite)WidgetFactory.composite((int)0).create((Widget)parent);
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(composite);
        Group fbInfoGroup = new Group(composite, 0);
        fbInfoGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        fbInfoGroup.setLayout((Layout)new GridLayout(4, false));
        fbInfoGroup.setText(Messages.SearchFor);
        this.instanceName = (Button)WidgetFactory.button((int)32).text(Messages.InstanceName).create((Widget)fbInfoGroup);
        this.pinName = (Button)WidgetFactory.button((int)32).text(Messages.PinName).create((Widget)fbInfoGroup);
        this.type = (Button)WidgetFactory.button((int)32).text(FordiacMessages.Type).create((Widget)fbInfoGroup);
        this.comment = (Button)WidgetFactory.button((int)32).text(Messages.Comment).create((Widget)fbInfoGroup);
        this.instanceName.setSelection(true);
        this.pinName.setSelection(false);
        this.type.setSelection(true);
        this.comment.setSelection(true);
        Composite searchBoxAndOptions = (Composite)WidgetFactory.composite((int)0).create((Widget)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(searchBoxAndOptions);
        LabelFactory labelFactory = LabelFactory.newLabel((int)0);
        labelFactory.text(Messages.ContainingText).create((Widget)composite);
        this.query = (Text)WidgetFactory.text((int)2048).message(Messages.TypeQuery).create((Widget)composite);
        this.query.setFocus();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.query);
        labelFactory.text(Messages.Jokers).create((Widget)composite);
        this.caseSensitive = (Button)WidgetFactory.button((int)32).text(Messages.CaseSensitive).create((Widget)composite);
        this.exactNameMatching = (Button)WidgetFactory.button((int)32).text(Messages.ExactNameMatching).create((Widget)composite);
        this.interfaceValueMatching = (Button)WidgetFactory.button((int)32).text(Messages.TypeInterfaceValueMatching).create((Widget)composite);
        Group radioButtonScope = new Group(composite, 0);
        radioButtonScope.setLayout((Layout)new RowLayout(512));
        radioButtonScope.setLayoutData((Object)new GridData(4, 4, true, false));
        radioButtonScope.setLayout((Layout)new GridLayout(2, false));
        radioButtonScope.setText(Messages.Scope);
        this.configureProjectScope(radioButtonScope);
        Button workspaceScope = new Button((Composite)radioButtonScope, 16);
        workspaceScope.setText(Messages.WorkspaceScope);
        workspaceScope.setSelection(!this.projectScope.getSelection());
        this.setControl((Control)composite);
    }

    private void configureProjectScope(Group radioButtonScope) {
        this.projectScope = new Button((Composite)radioButtonScope, 16);
        this.curProject = ModelSearchPage.getCurrentProject();
        this.projectScope.setEnabled(this.curProject != null);
        this.projectScope.setSelection(this.curProject != null);
        this.projectScope.setText(MessageFormat.format(Messages.ProjectScope, this.curProject != null ? this.curProject.getName() : "[none]"));
    }

    public boolean performAction() {
        boolean optionSelected;
        boolean isCheckedInstanceName = this.instanceName.getSelection();
        boolean isCheckedPinName = this.pinName.getSelection();
        boolean isCheckedType = this.type.getSelection();
        boolean isCheckedComment = this.comment.getSelection();
        boolean isCaseSensitive = this.caseSensitive.getSelection();
        boolean isExactNameMatching = this.exactNameMatching.getSelection();
        boolean isInterfaceValueMatching = this.interfaceValueMatching.getSelection();
        String searchString = this.query.getText();
        boolean bl = optionSelected = isCheckedInstanceName || isCheckedPinName || isCheckedType || isCheckedComment;
        if (!"".equals(searchString) && optionSelected) {
            ModelQuerySpec modelQuerySpec = new ModelQuerySpec(searchString, isCheckedInstanceName, isCheckedPinName, isCheckedType, isCheckedComment, isCaseSensitive, isExactNameMatching, isInterfaceValueMatching, this.getScope(), this.curProject);
            ModelSearchQuery searchJob = new ModelSearchQuery(modelQuerySpec);
            NewSearchUI.runQueryInBackground((ISearchQuery)searchJob, (ISearchResultViewPart)NewSearchUI.getSearchResultView());
            return true;
        }
        this.errorDialogDisplay();
        return false;
    }

    private ModelQuerySpec.SearchScope getScope() {
        if (this.projectScope.getSelection() && this.curProject != null) {
            return ModelQuerySpec.SearchScope.PROJECT;
        }
        return ModelQuerySpec.SearchScope.WORKSPACE;
    }

    private void errorDialogDisplay() {
        MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.Warning, (String)Messages.ErrorMessageSearch);
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private static IProject getCurrentProject() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IProject project = ModelSearchPage.getProjectFromActiveEditor(page);
        if (project == null) {
            project = ModelSearchPage.getProjectFromProjectExplorerSelction(page);
        }
        return project;
    }

    private static IProject getProjectFromActiveEditor(IWorkbenchPage page) {
        IEditorInput editorInput;
        IEditorPart openEditor = page.getActiveEditor();
        if (openEditor != null && (editorInput = openEditor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput ifEI = (IFileEditorInput)editorInput;
            return ifEI.getFile().getProject();
        }
        return null;
    }

    private static IProject getProjectFromProjectExplorerSelction(IWorkbenchPage page) {
        StructuredSelection structSel;
        CommonNavigator cn;
        ISelection selection;
        IViewPart view = page.findView("org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer");
        if (view instanceof CommonNavigator && (selection = (cn = (CommonNavigator)view).getCommonViewer().getSelection()) instanceof StructuredSelection && !(structSel = (StructuredSelection)selection).isEmpty()) {
            Object selElement = structSel.getFirstElement();
            if (selElement instanceof EObject) {
                EObject eo = (EObject)selElement;
                selElement = ModelSearchPage.getFileForModel(eo);
            }
            if (selElement instanceof IResource) {
                IResource iRes = (IResource)selElement;
                return iRes.getProject();
            }
        }
        return null;
    }

    private static IFile getFileForModel(EObject sel) {
        EObject root = EcoreUtil.getRootContainer((EObject)sel);
        if (root instanceof LibraryElement) {
            LibraryElement le = (LibraryElement)root;
            return le.getTypeEntry().getFile();
        }
        return null;
    }
}

