/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.search.ModelSearchResultEvent;
import org.eclipse.fordiac.ide.model.search.SearchNameDictionary;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;

public class ModelSearchResult
extends AbstractTextSearchResult {
    private final ISearchQuery modelSearchQuery;
    private final List<EObject> results;
    private final SearchNameDictionary dictionary;

    public ModelSearchResult(ISearchQuery job) {
        this.modelSearchQuery = job;
        this.results = new ArrayList<EObject>();
        this.dictionary = new SearchNameDictionary();
    }

    public String getLabel() {
        if (this.results.size() == 1) {
            return "'" + this.modelSearchQuery.getLabel() + "' - " + this.results.size() + " result";
        }
        return "'" + this.modelSearchQuery.getLabel() + "' - " + this.results.size() + " results";
    }

    public String getTooltip() {
        return "Found model elements";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.modelSearchQuery;
    }

    public void addResult(EObject res) {
        this.results.add(res);
        this.fireChange(this.getSearchResultEvent(res, 1));
    }

    public void addResults(List<? extends EObject> res) {
        this.results.addAll(res);
        if (!res.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(res.get(0), 1));
        }
    }

    private SearchResultEvent getSearchResultEvent(EObject el, int eventKind) {
        ModelSearchResultEvent searchResEvent = new ModelSearchResultEvent((ISearchResult)this);
        searchResEvent.setKind(eventKind);
        searchResEvent.setResult(el);
        return searchResEvent;
    }

    public List<EObject> getResults() {
        return this.results;
    }

    public SearchNameDictionary getDictionary() {
        return this.dictionary;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public void clear() {
        EObject first = this.results.isEmpty() ? null : this.results.get(0);
        this.results.clear();
        this.removeAll();
        this.fireChange(this.getSearchResultEvent(first, 2));
    }
}

