/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.gef.annotation.FordiacMarkerGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.validation.ValidationJob;
import org.eclipse.fordiac.ide.model.edit.ITypeEntryEditor;
import org.eclipse.fordiac.ide.model.edit.TypeEntryAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.dialog.AbstractTypeEntryDataHandler;
import org.eclipse.fordiac.ide.model.search.dialog.FBTypeUpdateDialog;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;
import org.eclipse.fordiac.ide.typeeditor.Messages;
import org.eclipse.fordiac.ide.typeeditor.TypeEditorInput;
import org.eclipse.fordiac.ide.typeeditor.TypeMultiPageEditorSite;
import org.eclipse.fordiac.ide.typeeditor.TypeTextMultiPageEditorSite;
import org.eclipse.fordiac.ide.typeeditor.internal.TypeEditorPageFactory;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.AbstractCloseAbleFormEditor;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.widget.SelectionTabbedPropertySheetPage;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.xtext.ui.editor.XtextEditor;

public abstract class AbstractTypeEditor
extends AbstractCloseAbleFormEditor
implements IGotoMarker,
CommandStackEventListener,
ITabbedPropertySheetPageContributor,
ITypeEntryEditor,
ISelectionListener {
    private static final int DEFAULT_BUTTON_INDEX = 0;
    private static final int CANCEL_BUTTON_INDEX = 1;
    private static TypeEditorPageFactory typeEditorPageFactory = new TypeEditorPageFactory();
    private final CommandStack commandStack = new CommandStack();
    private Collection<ITypeEditorPage> editorPages;
    private final TypeEntryAdapter adapter = new TypeEntryAdapter((ITypeEntryEditor)this);
    private GraphicalAnnotationModel annotationModel;
    private ValidationJob validationJob;

    protected void addPages() {
        TypeEditorInput ei = this.getTypeEditorInput();
        this.editorPages = typeEditorPageFactory.getEditors(this.getType());
        for (ITypeEditorPage typeEditorPage : this.editorPages) {
            try {
                typeEditorPage.setCommonCommandStack(this.getCommandStack());
                int index = this.addPage((IEditorPart)typeEditorPage, (IEditorInput)ei);
                this.setPageText(index, typeEditorPage.getTitle());
                this.setPageImage(index, typeEditorPage.getTitleImage());
            }
            catch (PartInitException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private TypeEditorInput checkEditorInput(IEditorInput editorInput) {
        if (editorInput instanceof TypeEditorInput) {
            TypeEditorInput typeEI = (TypeEditorInput)editorInput;
            return typeEI;
        }
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEI = (IFileEditorInput)editorInput;
            TypeEditorInput curEditorInput = this.getTypeEditorInput();
            if (curEditorInput != null) {
                return new TypeEditorInput(curEditorInput.getContent(), curEditorInput.getTypeEntry(), fileEI.getFile());
            }
            if (!fileEI.getFile().exists()) {
                return null;
            }
            TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileEI.getFile());
            if (typeEntry != null) {
                LibraryElement type = typeEntry.getTypeEditable();
                return new TypeEditorInput(type, typeEntry);
            }
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        if (this.getType() != null) {
            super.createPartControl(parent);
        } else {
            this.showLoadErrorMessage(parent);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            return new TypeTextMultiPageEditorSite((MultiPageEditorPart)this, editor);
        }
        return new TypeMultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    protected abstract AbstractTypeEntryDataHandler<? extends TypeEntry> createTypeEntryDataHandler();

    private MessageDialog createTypeUpdateDialog() {
        String[] labels = new String[]{Messages.TypeEditor_TypeUpdateDialog_SaveAndUpdate, SWT.getMessage((String)"SWT_Cancel")};
        return new FBTypeUpdateDialog(this.getSite().getShell(), Messages.TypeEditor_TypeUpdateDialog_Headline, Messages.TypeEditor_TypeUpdateDialog_Description, labels, 0, this.createTypeEntryDataHandler());
    }

    public void dispose() {
        TypeEntry typeEntry = this.getTypeEntry();
        if (typeEntry != null && typeEntry.eAdapters().contains((Object)this.adapter)) {
            typeEntry.eAdapters().remove((Object)this.adapter);
        }
        if (this.validationJob != null) {
            this.validationJob.dispose();
        }
        if (this.annotationModel != null) {
            this.annotationModel.dispose();
        }
        boolean dirty = this.isDirty();
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
        if (dirty && typeEntry != null) {
            typeEntry.setTypeEditable(null);
        }
        this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getTypeEntry() != null) {
            int result = 0;
            if (this.dependencyAffectingTypeChange()) {
                result = this.createTypeUpdateDialog().open();
            }
            switch (result) {
                case 0: {
                    this.doSaveInternal(monitor);
                    break;
                }
                case 1: {
                    MessageDialog.openInformation(null, (String)Messages.TypeEditor_WarningDialog_Headline, (String)Messages.TypeEditor_WarningDialog_NotSaved);
                    break;
                }
            }
        }
    }

    public void doSaveAs() {
    }

    private void doSaveInternal(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)this.getTypeEntry().getFile().getParent()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                AbstractTypeEditor.this.getEditorPages().stream().filter(ISaveablePart::isDirty).forEach(editorPart -> SafeRunner.run(() -> editorPart.doSave(monitor)));
                AbstractTypeEditor.this.getTypeEntry().save(AbstractTypeEditor.this.getType(), monitor);
            }
        };
        try {
            operation.run(monitor);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.getCommandStack().markSaveLocation();
    }

    protected abstract boolean dependencyAffectingTypeChange();

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == LibraryElement.class) {
            return adapter.cast(this.getType());
        }
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new SelectionTabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IGotoMarker.class) {
            return adapter.cast((Object)this);
        }
        if (adapter == GraphicalAnnotationModel.class) {
            return adapter.cast(this.annotationModel);
        }
        if (this.isEditorActive()) {
            Object result = super.getAdapter(adapter);
            if (result == null && AbstractTypeEditor.shouldCheckAllEditors(adapter)) {
                result = this.getEditorPages().stream().map(innerEditor -> Adapters.adapt((Object)innerEditor, (Class)adapter)).filter(Objects::nonNull).findFirst().orElse(null);
            }
            return (T)result;
        }
        return null;
    }

    private TypeEditorInput getTypeEditorInput() {
        TypeEditorInput typeEI;
        IEditorInput iEditorInput = super.getEditorInput();
        return iEditorInput instanceof TypeEditorInput ? (typeEI = (TypeEditorInput)iEditorInput) : null;
    }

    protected Collection<ITypeEditorPage> getEditorPages() {
        return this.editorPages;
    }

    public String getTitleToolTip() {
        String tooltip = this.getTypeEntry() != null ? this.getTypeEntry().getFullTypeName() + "\n" : "";
        return tooltip + super.getTitleToolTip();
    }

    protected LibraryElement getType() {
        TypeEditorInput ei = this.getTypeEditorInput();
        return ei != null ? ei.getContent() : null;
    }

    protected TypeEntry getTypeEntry() {
        TypeEditorInput ei = this.getTypeEditorInput();
        return ei != null ? ei.getTypeEntry() : null;
    }

    public void gotoMarker(IMarker marker) {
        int i = 0;
        for (ITypeEditorPage editorPart : this.getEditorPages()) {
            if (editorPart.isMarkerTarget(marker)) {
                this.setActivePage(i);
                editorPart.gotoMarker(marker);
                break;
            }
            ++i;
        }
    }

    private void handleContentOutlineSelection(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (!selection.isEmpty()) {
                Object selectedElement = sel.getFirstElement();
                int i = 0;
                for (ITypeEditorPage editorPart : this.getEditorPages()) {
                    if (editorPart.outlineSelectionChanged(selectedElement)) {
                        if (this.getActivePage() != i) {
                            this.setActivePage(i);
                        }
                        this.forwardSelectionToPropertySheet(part, selection);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void forwardSelectionToPropertySheet(IWorkbenchPart part, ISelection selection) {
        IViewPart propertySheetPart = this.getSite().getWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet");
        if (propertySheetPart instanceof PropertySheet) {
            PropertySheet propertySheet = (PropertySheet)propertySheetPart;
            propertySheet.selectionChanged(part, selection);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        super.init(site, editorInput);
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    private boolean isEditorActive() {
        int index = this.getActivePage();
        return index != -1 && !((CTabFolder)this.getContainer()).getItem(index).isDisposed();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private boolean isValidTypeEditorInput(TypeEditorInput typeEditorInput) {
        return typeEditorInput != null && typeEditorInput.getContent() != null && typeEditorInput.getTypeEntry() != null;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
    }

    public void reloadType() {
        LibraryElement curType;
        LibraryElement newFBType = this.getTypeEntry().getTypeEditable();
        if (newFBType != (curType = this.getType())) {
            TypeEditorInput typeEI;
            if (curType != null && this.getTypeEntry().eAdapters().contains((Object)this.adapter)) {
                this.getTypeEntry().eAdapters().remove((Object)this.adapter);
            }
            if ((typeEI = this.getTypeEditorInput()) != null) {
                typeEI.setType(newFBType);
            }
            this.getEditorPages().stream().forEach(ITypeEditorPage::reloadType);
            IEditorPart activeEditor = this.getActiveEditor();
            if (activeEditor instanceof ITypeEditorPage) {
                ITypeEditorPage editorPage = (ITypeEditorPage)activeEditor;
                Display.getDefault().asyncExec(() -> EditorUtils.refreshPropertySheetWithSelection((IEditorPart)this, (EditPartViewer)((EditPartViewer)activeEditor.getAdapter(GraphicalViewer.class)), (Object)editorPage.getSelectableObject()));
            }
            this.getCommandStack().flush();
            this.getTypeEntry().eAdapters().add((Object)this.adapter);
            this.setPartName(this.getTypeEntry().getTypeName());
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor()) && !(part instanceof PropertySheet)) {
            StructuredSelection structSel;
            Object object;
            if (selection instanceof StructuredSelection && (object = (structSel = (StructuredSelection)selection).getFirstElement()) instanceof URI) {
                URI uri = (URI)object;
                EObject selectedElement = this.getType().eResource().getEObject(uri.fragment());
                if (selectedElement instanceof FBNetworkElement || selectedElement instanceof Algorithm || selectedElement instanceof Method || selectedElement instanceof VarDeclaration) {
                    this.handleContentOutlineSelection(part, (ISelection)new StructuredSelection((Object)selectedElement));
                }
            } else if (part instanceof ContentOutline) {
                this.handleContentOutlineSelection(part, selection);
            }
        }
    }

    public void setFocus() {
        super.setFocus();
        this.adapter.checkFileReload();
    }

    public void setInput(IEditorInput input) {
        TypeEditorInput typeEditorInput;
        if (this.validationJob != null) {
            this.validationJob.dispose();
            this.validationJob = null;
        }
        if (this.annotationModel != null) {
            this.annotationModel.dispose();
            this.annotationModel = null;
        }
        if (input != null) {
            this.setPartName(TypeEntry.getTypeNameFromFileName((String)input.getName()));
        }
        if (this.isValidTypeEditorInput(typeEditorInput = this.checkEditorInput(input))) {
            typeEditorInput.getTypeEntry().eAdapters().add((Object)this.adapter);
            this.annotationModel = new FordiacMarkerGraphicalAnnotationModel((IResource)typeEditorInput.getFile(), typeEditorInput::getContent);
            this.validationJob = new ValidationJob(this.getPartName(), this.getCommandStack(), this.annotationModel);
            if (this.getEditorPages() != null) {
                this.getEditorPages().forEach(e -> e.setInput((IEditorInput)typeEditorInput));
            }
            this.setInputWithNotify((IEditorInput)typeEditorInput);
        } else {
            this.setInputWithNotify(input);
        }
    }

    public void showLoadErrorMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)composite);
        Image image = Display.getDefault().getSystemImage(1);
        Label imageLabel = new Label(composite, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(MessageFormat.format(Messages.TypeEditor_CouldNotLoadType, this.getEditorInput().getName()));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)messageLabel);
    }

    private static <T> boolean shouldCheckAllEditors(Class<T> adapter) {
        return adapter == ITextEditor.class || adapter == XtextEditor.class || adapter == FBNetworkEditor.class;
    }

    public void stackChanged(CommandStackEvent event) {
        this.firePropertyChange(257);
    }
}

