/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.gef.commands.Command;

public class ChangeDocumentationCommand
extends Command
implements ScopedCommand {
    private final LibraryElement type;
    private final String newDocumentation;
    private String oldDocumentation;

    public ChangeDocumentationCommand(LibraryElement type, String newDocumenation) {
        this.type = Objects.requireNonNull(type);
        this.newDocumentation = newDocumenation == null ? "" : newDocumenation;
    }

    public void execute() {
        this.oldDocumentation = this.type.getDocumentation();
        this.setDocumentation(this.newDocumentation);
    }

    public void undo() {
        this.setDocumentation(this.oldDocumentation);
    }

    public void redo() {
        this.setDocumentation(this.newDocumentation);
    }

    private void setDocumentation(String newValue) {
        this.type.setDocumentation(newValue);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.type);
    }
}

