/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkElementHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class NegateConnectionCommand
extends Command
implements ScopedCommand {
    private final Connection connection;
    private final boolean isNegated;

    public NegateConnectionCommand(Connection connection, boolean isNegated) {
        this.connection = Objects.requireNonNull(connection);
        this.isNegated = isNegated;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.connection.getSource(), this.connection.getDestination());
    }

    public boolean canExecute() {
        EObject eObject = this.connection.getFBNetwork().eContainer();
        if (eObject instanceof FBNetworkElement) {
            SubApp subApp;
            FBNetworkElement fbnEl = (FBNetworkElement)eObject;
            if (fbnEl instanceof SubApp && (subApp = (SubApp)fbnEl).isTyped() || fbnEl instanceof CFBInstance) {
                return false;
            }
            return !FBNetworkElementHelper.isContainedInTypedInstance((FBNetworkElement)fbnEl);
        }
        return true;
    }

    public void execute() {
        this.setNegated(this.isNegated);
    }

    public void undo() {
        this.setNegated(!this.isNegated);
    }

    public void redo() {
        this.setNegated(this.isNegated);
    }

    public void setNegated(boolean negated) {
        this.connection.setNegated(negated);
    }
}

