/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentNetwork;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.editparts.InstanceName;
import org.eclipse.fordiac.ide.application.editparts.InstanceNameEditPart;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.application.figures.GroupFigure;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.application.figures.InstanceNameFigure;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteGroupCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class GroupEditPart
extends AbstractPositionableElementEditPart
implements IContainerEditPart,
AnnotableGraphicalEditPart {
    private GroupContentNetwork groupContents;
    private InstanceName instanceName;

    public Group getModel() {
        return (Group)super.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    public Label getNameLabel() {
        return null;
    }

    protected void refreshName() {
    }

    @Override
    public Rectangle getCommentBounds() {
        if (this.getFigure().getCommentFigure() != null) {
            return this.getFigure().getCommentFigure().getBounds();
        }
        return null;
    }

    protected void refreshSourceConnections() {
        this.getContentEP().getChildren().forEach(ep -> {
            if (ep instanceof AbstractFBNElementEditPart) {
                AbstractFBNElementEditPart fbEp = (AbstractFBNElementEditPart)((Object)ep);
                fbEp.getChildren().forEach(pinEp -> {
                    if (pinEp instanceof InterfaceEditPartForFBNetwork) {
                        pinEp.getSourceConnections().forEach(EditPart::refresh);
                    }
                });
            }
        });
    }

    protected void refreshTargetConnections() {
        this.getContentEP().getChildren().forEach(ep -> {
            if (ep instanceof AbstractFBNElementEditPart) {
                AbstractFBNElementEditPart fbEp = (AbstractFBNElementEditPart)((Object)ep);
                fbEp.getChildren().forEach(pinEp -> {
                    if (pinEp instanceof InterfaceEditPartForFBNetwork) {
                        pinEp.getTargetConnections().forEach(EditPart::refresh);
                    }
                });
            }
        });
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getGroup_GroupElements().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                    GroupEditPart.this.getParent().refresh();
                } else if (LibraryElementPackage.eINSTANCE.getGroup_Width().equals(feature) || LibraryElementPackage.eINSTANCE.getGroup_Height().equals(feature)) {
                    GroupEditPart.this.refreshPosition();
                }
            }
        };
    }

    protected IFigure createFigureForModel() {
        GroupFigure groupFigure = new GroupFigure();
        groupFigure.getCommentFigure().setText(this.getModel().getComment());
        return groupFigure;
    }

    public GroupFigure getFigure() {
        return (GroupFigure)super.getFigure();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (child instanceof InstanceNameFigure) {
            this.getFigure().getNameFigure().add(child, (Object)new GridData(544));
        } else {
            GridData layoutConstraint = new GridData(1808);
            this.getFigure().getMainFigure().add(child, (Object)layoutConstraint);
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>(3);
        if (this.instanceName == null) {
            this.instanceName = new InstanceName((FBNetworkElement)this.getModel());
        }
        children.add(this.instanceName);
        children.add(this.getGroupContents());
        return children;
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && request instanceof SelectionRequest) {
            SelectionRequest selReq = (SelectionRequest)request;
            GroupContentEditPart groupContentEP = this.getGroupContentEP();
            if (groupContentEP != null && this.isGroupContentTargetingRequest(selReq, groupContentEP)) {
                groupContentEP.performRequest(request);
                return;
            }
        }
        super.performRequest(request);
    }

    protected void performDirectEdit() {
        new TextDirectEditManager(this, (CellEditorLocator)new FigureCellEditorLocator((IFigure)this.getFigure().getCommentFigure())){

            protected CellEditor createCellEditorOn(Composite composite) {
                return new TextCellEditor(composite, 66);
            }

            protected void initCellEditor() {
                super.initCellEditor();
                this.getCellEditor().setValue((Object)GroupEditPart.this.getModel().getComment());
            }
        }.show();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest request) {
                return new DeleteGroupCommand((Group)this.getHost().getModel());
            }
        });
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new GroupCommentRenameEditPolicy());
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Position position = this.getModel().getPosition();
            Point asPoint = position.toScreenPoint();
            Rectangle bounds = new Rectangle(asPoint, this.getGroupSize());
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
        }
    }

    protected void refreshComment() {
        this.getFigure().getCommentFigure().setText(this.getModel().getComment());
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest) {
            SelectionRequest selReq = (SelectionRequest)request;
            GroupContentEditPart groupContentEP = this.getGroupContentEP();
            if (groupContentEP != null && this.isGroupContentTargetingRequest(selReq, groupContentEP)) {
                return groupContentEP.getDragTracker(request);
            }
        }
        return super.getDragTracker(request);
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == Group.class) {
            return key.cast(this.getModel());
        }
        return (T)super.getAdapter(key);
    }

    @Override
    public GraphicalEditPart getContentEP() {
        return this.getChildren().stream().filter(GroupContentEditPart.class::isInstance).findAny().orElse(null);
    }

    private Dimension getGroupSize() {
        return new Dimension(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getModel().getWidth()), CoordinateConverter.INSTANCE.iec61499ToScreen(this.getModel().getHeight()));
    }

    private GroupContentEditPart getGroupContentEP() {
        return this.getChildren().stream().filter(GroupContentEditPart.class::isInstance).findAny().orElse(null);
    }

    private GroupContentNetwork getGroupContents() {
        if (this.groupContents == null) {
            this.groupContents = new GroupContentNetwork(this.getModel());
        }
        return this.groupContents;
    }

    boolean isGroupContentTargetingRequest(SelectionRequest request, GroupContentEditPart groupContentEP) {
        Point location = request.getLocation().getCopy();
        this.getFigure().translateToRelative((Translatable)location);
        return groupContentEP != null && groupContentEP.getFigure().getBounds().contains(location);
    }

    @Override
    public int getCommentWidth() {
        return this.getFigure().getCommentFigure().getTextWidth();
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        this.getChildren().stream().filter(InstanceNameEditPart.class::isInstance).map(InstanceNameEditPart.class::cast).forEach(child -> child.updateAnnotations(event));
    }

    private class GroupCommentRenameEditPolicy
    extends AbstractViewRenameEditPolicy {
        private GroupCommentRenameEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            GraphicalEditPart graphicalEditPart = this.getHost();
            if (graphicalEditPart instanceof GroupEditPart) {
                GroupEditPart gEP = (GroupEditPart)graphicalEditPart;
                String str = (String)request.getCellEditor().getValue();
                if (!InstanceCommentFigure.EMPTY_COMMENT.equals(str)) {
                    return new ResizeGroupOrSubappCommand(this.getHost(), (Command)new ChangeCommentCommand((INamedElement)gEP.getModel(), str));
                }
            }
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            GroupEditPart.this.getFigure().getCommentFigure().setText(value);
        }

        protected void revertOldEditValue(DirectEditRequest request) {
            GroupEditPart.this.refreshComment();
        }
    }
}

