/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.listeners;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.handlers.MarkPredecessorHandler;
import org.eclipse.fordiac.ide.model.commands.QualNameChange;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListener;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.ui.IEditorPart;

public class PredecessorQualifiedNameListener
extends QualNameChangeListener {
    public void onCommandExecuted(List<QualNameChange> qualNameChange) {
        PredecessorQualifiedNameListener.updateMarkerEntries(qualNameChange);
        super.onCommandExecuted(qualNameChange);
    }

    public void onCommandUndoExecuted(List<QualNameChange> qualNameChange) {
        PredecessorQualifiedNameListener.updateMarkerEntries(qualNameChange);
        super.onCommandUndoExecuted(qualNameChange);
    }

    public void onCommandRedoExecuted(List<QualNameChange> qualNameChange) {
        PredecessorQualifiedNameListener.updateMarkerEntries(qualNameChange);
        super.onCommandRedoExecuted(qualNameChange);
    }

    protected List<AbstractOperation> constructExecutableOperations(QualNameChange change, Object receiver) {
        return Collections.emptyList();
    }

    protected List<AbstractOperation> constructExecutableUndoOperations(QualNameChange change, Object receiver) {
        return Collections.emptyList();
    }

    protected Object getReceiver(TypeEntry key) {
        return null;
    }

    protected void executeOperation(AbstractOperation op) {
    }

    private static void updateMarkerEntries(List<QualNameChange> qualNameChange) {
        qualNameChange.stream().filter(change -> change.newQualName() == null).map(QualNameChange::notifier).filter(MarkPredecessorHandler::hasPredecessorMarker).forEach(t -> {
            FBNetworkElement fbe;
            AbstractFBNElementEditPart ep;
            RootEditPart rootEditPart;
            if (t instanceof FBNetworkElement && (rootEditPart = (ep = PredecessorQualifiedNameListener.getEP(fbe = (FBNetworkElement)t)).getRoot()) instanceof FBNetworkRootEditPart) {
                FBNetworkRootEditPart root = (FBNetworkRootEditPart)rootEditPart;
                MarkPredecessorHandler.removePredecessor(root);
            }
        });
        qualNameChange.stream().map(QualNameChange::notifier).filter(MarkPredecessorHandler::hasPredecessorMarker).forEach(t -> {
            FBNetworkElement fbe;
            AbstractFBNElementEditPart ep;
            RootEditPart rootEditPart;
            if (t instanceof FBNetworkElement && (rootEditPart = (ep = PredecessorQualifiedNameListener.getEP(fbe = (FBNetworkElement)t)).getRoot()) instanceof FBNetworkRootEditPart) {
                FBNetworkRootEditPart root = (FBNetworkRootEditPart)rootEditPart;
                MarkPredecessorHandler.setPredecessor(root, ep);
            }
        });
    }

    private static AbstractFBNElementEditPart getEP(FBNetworkElement elem) {
        GraphicalViewer viewer;
        EditPart editPart;
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null && (editPart = (EditPart)(viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class)).getEditPartRegistry().get(elem)) instanceof AbstractFBNElementEditPart) {
            AbstractFBNElementEditPart ep = (AbstractFBNElementEditPart)editPart;
            return ep;
        }
        return null;
    }
}

