/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationDataLayer;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CheckBoxConfigurationNebula;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnEditableRule;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class VarConfigurationSection
extends AbstractSection {
    private NatTable inputTable;
    private IChangeableRowDataProvider<VarDeclaration> inputDataProvider;
    private static String separationPoint = ".";
    private TypedSubApp rootTSA;
    private final Map<String, VarDeclaration> displayMap = new LinkedHashMap<String, VarDeclaration>();
    private static final Map<VarDeclaration, Boolean> copiedMap = new HashMap<VarDeclaration, Boolean>();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTableSection(parent);
    }

    private void createTableSection(Composite parent) {
        Composite tableSectionComposite = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(tableSectionComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableSectionComposite);
        Group inputComposite = this.getWidgetFactory().createGroup(tableSectionComposite, Messages.VarConfigurationSection_VarConfigs);
        GridLayoutFactory.fillDefaults().applyTo((Composite)inputComposite);
        this.inputDataProvider = new ChangeableListDataProvider((IColumnAccessor)new VarConfigDeclarationColumnAccessor(this));
        VarDeclarationDataLayer inputDataLayer = new VarDeclarationDataLayer(this.inputDataProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG);
        inputDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new VarDeclarationConfigLabelAccumulator(this.inputDataProvider, () -> ((VarConfigurationSection)this).getAnnotationModel(), VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG));
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG);
        this.inputTable = NatTableWidgetFactory.createNatTable((Composite)inputComposite, (DataLayer)inputDataLayer, (IDataProvider)columnProvider, (IEditableRule)new NatTableColumnEditableRule((IEditableRule)new VarConfigEditableRule(), VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG, VarDeclarationTableColumn.DEFAULT_EDITABLE));
        this.inputTable.addConfiguration((IConfiguration)new CheckBoxConfigurationNebula());
        this.inputTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, (CommandExecutor)this));
        this.inputTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)inputComposite);
        tableSectionComposite.layout();
    }

    protected INamedElement getInputType(Object input) {
        if (input instanceof FBNetworkEditPart) {
            FBNetworkEditPart fbnEP = (FBNetworkEditPart)((Object)input);
            return fbnEP.getModel().getApplication();
        }
        if (input instanceof INamedElement) {
            INamedElement namedElement = (INamedElement)input;
            return namedElement;
        }
        if (input instanceof SubAppForFBNetworkEditPart) {
            SubAppForFBNetworkEditPart safbnEp = (SubAppForFBNetworkEditPart)input;
            return safbnEp.getModel();
        }
        return null;
    }

    protected INamedElement getType() {
        if (this.type instanceof Application || this.type instanceof FB || this.type instanceof SubApp || this.type instanceof CFBInstance || this.type instanceof TypedSubApp) {
            return (INamedElement)this.type;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
        this.inputDataProvider.setInput(this.collectVarConfigs());
        this.inputTable.refresh();
    }

    protected void performRefresh() {
        this.inputTable.refresh();
    }

    protected void performRefreshAnnotations() {
        this.inputTable.refresh(false);
    }

    private List<VarDeclaration> collectVarConfigs() {
        this.displayMap.clear();
        HashSet<INamedElement> visited = new HashSet<INamedElement>();
        this.collectVarConfigsRecursive(this.getType(), this.displayMap, visited, "");
        return new ArrayList<VarDeclaration>(this.displayMap.values());
    }

    private void collectVarConfigsRecursive(INamedElement type, Map<String, VarDeclaration> result, Set<INamedElement> visited, String currentPrefix) {
        if (!visited.add(type)) {
            return;
        }
        INamedElement iNamedElement = type;
        Objects.requireNonNull(iNamedElement);
        INamedElement iNamedElement2 = iNamedElement;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypedSubApp.class, UntypedSubApp.class, SubAppType.class, Application.class}, (Object)iNamedElement2, 0)) {
            case 0: {
                TypedSubApp tsa = (TypedSubApp)iNamedElement2;
                VarConfigurationSection.traverseInterfaceElements(tsa, result, visited, currentPrefix);
                this.traverseFBNetwork((Iterable<FBNetworkElement>)tsa.getType().getFBNetwork().getNetworkElements(), result, visited, currentPrefix);
                break;
            }
            case 1: {
                UntypedSubApp utsa = (UntypedSubApp)iNamedElement2;
                this.traverseFBNetwork((Iterable<FBNetworkElement>)utsa.getSubAppNetwork().getNetworkElements(), result, visited, currentPrefix);
                break;
            }
            case 2: {
                SubAppType sat = (SubAppType)iNamedElement2;
                this.traverseFBNetwork((Iterable<FBNetworkElement>)sat.getFBNetwork().getNetworkElements(), result, visited, currentPrefix);
                break;
            }
            case 3: {
                Application app = (Application)iNamedElement2;
                this.traverseFBNetwork((Iterable<FBNetworkElement>)app.getFBNetwork().getNetworkElements(), result, visited, currentPrefix);
                break;
            }
        }
    }

    private static void traverseInterfaceElements(TypedSubApp tsa, Map<String, VarDeclaration> result, Set<INamedElement> visited, String currentPrefix) {
        for (IInterfaceElement elem : tsa.getInterface().getAllInterfaceElements()) {
            VarDeclaration vd;
            if (!(elem instanceof VarDeclaration) || !(vd = (VarDeclaration)elem).isVarConfig()) continue;
            VarConfigurationSection.addOriginalElement(vd, currentPrefix, result);
        }
    }

    private void traverseFBNetwork(Iterable<FBNetworkElement> elements, Map<String, VarDeclaration> result, Set<INamedElement> visited, String currentPrefix) {
        for (FBNetworkElement fbne : elements) {
            String prefix = currentPrefix + fbne.getName() + separationPoint;
            boolean shouldCopy = !VarConfigurationSection.isPartOfEditedStructure(this.getType(), (EObject)fbne);
            this.addPossibleVarConfigs(fbne, result, prefix, shouldCopy);
            if (fbne.getType() != null) {
                this.collectVarConfigsRecursive((INamedElement)fbne.getType(), result, visited, prefix);
            }
            if (!(fbne instanceof UntypedSubApp)) continue;
            UntypedSubApp usa = (UntypedSubApp)fbne;
            this.traverseFBNetwork((Iterable<FBNetworkElement>)usa.getSubAppNetwork().getNetworkElements(), result, visited, currentPrefix);
        }
    }

    private static boolean isPartOfEditedStructure(INamedElement root, EObject obj) {
        EObject current = obj;
        while (current != null) {
            if (current == root) {
                return true;
            }
            if ((current instanceof Application || current instanceof SubAppType) && current != root) {
                return false;
            }
            current = current.eContainer();
        }
        return false;
    }

    private void addPossibleVarConfigs(FBNetworkElement fbne, Map<String, VarDeclaration> result, String prefix, boolean shouldCopy) {
        for (IInterfaceElement elem : fbne.getInterface().getAllInterfaceElements()) {
            VarDeclaration vd;
            if (!(elem instanceof VarDeclaration) || !(vd = (VarDeclaration)elem).isVarConfig()) continue;
            if (shouldCopy) {
                this.addAndCopyElement(vd, prefix, result);
                continue;
            }
            VarConfigurationSection.addOriginalElement(vd, prefix, result);
        }
    }

    private static void addOriginalElement(VarDeclaration vd, String currentPrefix, Map<String, VarDeclaration> result) {
        String qualifiedName = currentPrefix + vd.getName();
        if (result.containsKey(qualifiedName)) {
            return;
        }
        result.put(qualifiedName, vd);
        copiedMap.put(vd, Boolean.FALSE);
    }

    private void addAndCopyElement(VarDeclaration vd, String currentPrefix, Map<String, VarDeclaration> result) {
        VarDeclaration targetVD;
        String qualifiedName = currentPrefix + vd.getName();
        if (result.containsKey(qualifiedName)) {
            return;
        }
        String subAppTypeName = qualifiedName.split("\\.")[0];
        INamedElement iNamedElement = this.getType();
        Objects.requireNonNull(iNamedElement);
        INamedElement iNamedElement2 = iNamedElement;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Application.class, TypedSubApp.class, UntypedSubApp.class}, (Object)iNamedElement2, 0)) {
            case 0: {
                Application app = (Application)iNamedElement2;
                this.rootTSA = (TypedSubApp)app.getFBNetwork().getNetworkElements().stream().filter(x -> x.getName().equals(subAppTypeName)).toList().getFirst();
                break;
            }
            case 1: {
                TypedSubApp tsa;
                this.rootTSA = tsa = (TypedSubApp)iNamedElement2;
                break;
            }
            case 2: {
                UntypedSubApp usa = (UntypedSubApp)iNamedElement2;
                this.rootTSA = VarConfigurationSection.findTypedSubAppByTypeNameInUntypedSubApp(usa, subAppTypeName);
                break;
            }
        }
        String relativeName = this.rootTSA != null ? VarConfigurationSection.getRelativeName(qualifiedName, this.rootTSA.getName()) : qualifiedName;
        VarDeclaration existing = null;
        if (this.rootTSA != null) {
            VarDeclaration varDeclaration = existing = this.rootTSA != null ? (VarDeclaration)this.rootTSA.getVarConfigParams().stream().filter(v -> v.getName().equals(relativeName)).findFirst().orElse(null) : null;
        }
        if (existing != null) {
            targetVD = existing;
        } else {
            targetVD = (VarDeclaration)EcoreUtil.copy((EObject)vd);
            targetVD.setName(relativeName);
            if (vd.getValue() != null) {
                targetVD.setValue((Value)EcoreUtil.copy((EObject)vd.getValue()));
            }
            targetVD.setComment(vd.getComment());
            targetVD.getAttributes().clear();
            this.rootTSA.getVarConfigParams().add((Object)targetVD);
        }
        result.put(qualifiedName, targetVD);
        copiedMap.put(targetVD, Boolean.TRUE);
    }

    private static TypedSubApp findTypedSubAppByTypeNameInUntypedSubApp(UntypedSubApp root, String satName) {
        for (FBNetworkElement element : root.getSubAppNetwork().getNetworkElements()) {
            UntypedSubApp nested;
            TypedSubApp result;
            TypedSubApp tsa;
            if (element instanceof TypedSubApp && (tsa = (TypedSubApp)element).getType().getName().equals(satName)) {
                return tsa;
            }
            if (!(element instanceof UntypedSubApp) || (result = VarConfigurationSection.findTypedSubAppByTypeNameInUntypedSubApp(nested = (UntypedSubApp)element, satName)) == null) continue;
            return result;
        }
        return null;
    }

    private static String getRelativeName(String qualifiedName, String rootName) {
        if (qualifiedName.startsWith(rootName + separationPoint)) {
            return qualifiedName.substring(rootName.length() + 1);
        }
        return qualifiedName;
    }

    public String getDisplayName(VarDeclaration varDecl) {
        return this.displayMap.entrySet().stream().filter(e -> e.getValue() == varDecl).map(Map.Entry::getKey).findFirst().orElse(varDecl.getName());
    }

    private static class VarConfigDeclarationColumnAccessor
    extends VarDeclarationColumnAccessor {
        private VarConfigDeclarationColumnAccessor(VarConfigurationSection section) {
            super((CommandExecutor)section, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG);
        }

        public Object getDataValue(VarDeclaration rowObject, int columnIndex) {
            if (columnIndex == VarDeclarationTableColumn.NAME.ordinal()) {
                return this.getCommandExecutor().getDisplayName(rowObject);
            }
            return super.getDataValue((Object)rowObject, columnIndex);
        }

        protected VarConfigurationSection getCommandExecutor() {
            return (VarConfigurationSection)super.getCommandExecutor();
        }
    }

    private class VarConfigEditableRule
    implements IEditableRule {
        private VarConfigEditableRule() {
        }

        public boolean isEditable(ILayerCell cell, IConfigRegistry configRegistry) {
            Object rowObject = cell.getDataValue();
            int columnIndex = cell.getColumnIndex();
            return this.checkEditable(columnIndex, rowObject);
        }

        public boolean isEditable(int columnIndex, int rowIndex) {
            Object rowObject = VarConfigurationSection.this.inputDataProvider.getRowObject(rowIndex);
            return this.checkEditable(columnIndex, rowObject);
        }

        private boolean checkEditable(int columnIndex, Object rowObject) {
            if (rowObject instanceof VarDeclaration) {
                VarDeclaration vd = (VarDeclaration)rowObject;
                VarDeclarationTableColumn col = VarDeclarationTableColumn.values()[columnIndex];
                if (col == VarDeclarationTableColumn.VISIBLE || col == VarDeclarationTableColumn.VAR_CONFIG) {
                    return this.isInsideOwnNetwork(vd);
                }
            }
            return true;
        }

        private boolean isInsideOwnNetwork(VarDeclaration vd) {
            return !Boolean.TRUE.equals(copiedMap.get(vd));
        }
    }
}

